<?php
/*
Plugin Name: WooCommerce BtPayments
Plugin URI: https://www.btpayments.io/
Description: Integrates your BtPayments payment gateway into your WooCommerce installation.
Version: 0.2.1
Author: BtPayments
Text Domain: BtPayments
Author URI: https://www.btpayments.io/
*/
add_action('plugins_loaded', 'init_btpayments_gateway', 0);

function init_btpayments_gateway() {
	if( !class_exists('WC_Payment_Gateway') )  return;
	
	require_once('class-wc-gateway-btpayments.php');
	
	// Add the gateway to WooCommerce
	function add_btpayments_gateway( $methods )
	{
		return array_merge($methods, 
				array(
						'WC_Gateway_BtPayments'));
	}
	add_filter('woocommerce_payment_gateways', 'add_btpayments_gateway' );
	
	function wc_btpayments_plugin_edit_link( $links ){
		return array_merge(
				array(
						'settings' => '<a href="' . admin_url( 'admin.php?page=wc-settings&tab=checkout') . '">'.__( 'Settings', 'alipay' ).'</a>'
				),
				$links
		);
	}
	add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'wc_btpayments_plugin_edit_link' );
}
require 'includes/functions_payments.php';
?>
